<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<SearchViewModel>" %>

<div id="searchResultsStatic" class="panel searchResults">
    <%
        var hasRadius = Model.Criteria is AdvancedSearchQuery && ((AdvancedSearchQuery)Model.Criteria).Radius.HasValue;
        var actionName = Model.AdvancedMode ? "Advanced" : "Search";
    %>
    <div class="innerPanel">
        <h2>
            <ul>
                <li class="flex">
                    <strong><a href="<%=Url.Content("~/")%>">Go Back</a> Itineraries for '<%:Model.SearchActivity.Name%>'</strong>
                </li>
            </ul>
        </h2>
            <div class="items">
                <% if(Model.Items == null) %>
                <% { %>
                    <h3>Please provide a search criteria...</h3>
                <% } else { %>
                    <% if(Model.TotalPages == 0) %>
                    <% { %>
                        <h3>No itineraries found...</h3>
                    <% } else {%>
                        <ul class="itineraries">
                            <% foreach (var itinerary in Model.Items as IEnumerable<ItineraryViewModel>) %>
                            <% { %>
                                <li>
                                    <span class="off id"><%:itinerary.Id%></span>
                                    <h3>
                                        <span class="rating <%=ItineraryHelper.GetRatingCssClass(itinerary.Rating)%>"><span>Rating: </span><%=ItineraryHelper.GetRatingLabel(itinerary.Rating)%></span>
                                        <a href="<%=Html.AttributeEncode(itinerary.DetailsLink)%>"><%:itinerary.Name%></a>
                                    </h3>
                                    <p>
                                        <span style="float: right; font-size: .75em">Created on <%:itinerary.Created.ToShortDateString() %></span>
                                        <% if(!String.IsNullOrEmpty(itinerary.Description)) { %><%:itinerary.Description%><br /><% } %>
                                        <% if(itinerary.EstimatedMinutes > 0) { %>Estimated time: <%:TimeHelper.GetFriendlyTime(itinerary.EstimatedMinutes)%><br /><% } %>
                                    </p>
                                    <p class="children">
                                        <a href="<%=Html.AttributeEncode(itinerary.DetailsLink)%>" class="ajax">View Activities (<%=itinerary.ActivitiesCount%>)</a>
                                    </p>
                                </li>
                            <% } %>
                        </ul>
                    <% } %>
                <% } %>
            </div>
            
            <div class="toolbox">
            <% if (Model.TotalPages > 0) %>
            <% { %>
                <div class="pager">
                    <% if (string.IsNullOrEmpty(Model.PreviousPageLink)) %>
                    <% { %>
                         Previous
                    <% } else { %>
                        <a href="<%=Html.AttributeEncode(Model.PreviousPageLink)%>"> Previous</a>
                    <% } %>
                    |
                    <strong>Page <%=Model.CurrentPage%></strong>
                    |
                    <% if (string.IsNullOrEmpty(Model.NextPageLink)) %>
                    <% { %>
                        Next 
                    <% } else { %>
                        <a href="<%=Html.AttributeEncode(Model.NextPageLink)%>">Next </a>
                    <% } %>
                </div>
            <% } %>
            </div>
    </div>
</div>